<?php 
/** 
* Clase para la creacin de un panel de fichas (tab control) 
* 
* @author Alfredo Rahn <arahn@thor.uc.edu.ve> 
* @version 0.2 (24-09-2005) 
* @version 0.1 (30-06-2005) 
*/ 

/** 
* Clase que crea un panel de fichas html 
*/ 
class panel_Fichas { 
    /** 
    * El vector con la configuracin de las fichas 
    */ 
    var $CFG; 
    /** 
    * El key de la lista activa 
    */ 
    var $Activa; 
    /** 
    * La cantidad de filas entre las que vamos a distribuir las fichas 
    */ 
    var $Filas; 
    /** 
    * Cadena con los atributos de despliegue de la tabla 
    */ 
    var $TAttr; 
    /** 
    * Cadena con los atributos de despliegue de la celda activa 
    */ 
    var $ACAttr; 
    /** 
    * Cadena con los atributos de despliegue de la celda inactiva 
    */ 
    var $ICAttr; 
    /** 
    * El nombre de la variable que contiene la ficha activa 
    */ 
    var $FA_name; 
    /** 
    * Constructor de la Clase 
    * 
    * @param array $Fichas Vector referencial con la configuracin 
    * @param mixed $Activa La llave de la ficha activa (o cero la primera) 
    * @param string $TAttr Los atributos para el despliegue de la tabla 
    * @param string $ACAttr Atributos para el despliegue de celda activa 
    * @param string $ICAttr Atributos para el despliegue de celda activa 
    * @param number $filas Nmero de filas a desplegar 
    * @param string $FA_name El nombre de la variable de la ficha activa 
    */ 
    function panel_Fichas(  $Fichas=array(), 
                            $Activa=0, 
                            $TAttr="", 
                            $ACAttr="", 
                            $ICAttr="", 
                            $filas=1, 
                            $FA_name="ficha") { 
        // Si hay elementos en el vector Fichas 
        if ($bueno=    !empty($Fichas) && is_array($Fichas)) 
            // Si estos elementos al menos tienen etiqueta 
            foreach(array_keys($Fichas) as $key) 
                if (!($bueno = strlen($Fichas[$key][LABEL]) > 0)) 
                    continue; 
        // Si bueno es true, es que el array sirvio para algo 
        $this->CFG = $bueno ? $Fichas : array(); 

        // La ficha activa         
        $this->Activa = ($Activa != 0) && 
                        in_array($Activa,array_keys($this->CFG)) ? 
                        $Activa : 
                        0; 
        // Los atributos de formato 
        $this->TAttr  = (!empty($TAttr)) ? 
                        $TAttr : 
                        ""; 
        $this->ACAttr = (!empty($ACAttr)) ? 
                        $ACAttr : 
                        ""; 
        $this->ICAttr = (!empty($ICAttr)) ? 
                        $ICAttr : 
                        ""; 
        // El nombre de la variable de la ficha activa 
        $this->FA_name = (strlen($FA_Name) > 0) && 
                         (htmlentities($FA_Name) == $FA_Name) ? 
                         $FA_Name : 
                         "ficha"; 
    } 
    /** 
    * Inserta una nueva ficha 
    * 
    * @param string $llave El nombre o numero de llave 
    * @param string $titulo El titulo a mostrar para la ficha 
    * @param string $valor El valor o contenido de la ficha 
    * @param string $tipo El tipo de valor o contenido 
    */ 
    function nuevaFicha($llave,$titulo,$valor="",$tipo="") { 
        // Si algo anda mal se va 
        if (empty($key) || 
            empty($value) || 
            !is_numeric($pos) || 
            (int)$pos >= 0) return false; 
        // Monta el valor en el vector 
        $this->Elem = array_merge($this->Elem, 
                                  array($key => $value)); 
        // Si esta en el de posiciones tambien 
        if ($pos > 0) $this->Pos[$key] = $pos; 
        return true; 
    } 
    /** 
    * Elimina una Ficha 
    * 
    * @param string $llave La llave que identifica la ficha a borrar 
    */ 
    function borrarFicha($llave) { 
        // Si no existe nos vamos 
        if (!isset($this->Elem[$key])) return false; 
        // Si existe en el vector de elementos, borralo 
        unset($this->Elem[$key]); 
        // Si esta en el vector de posiciones borralo 
        if (isset($this->Pos[$key])) unset($this->Pos[$key]); 
        return true; 
    } 
    /** 
    * Activa o desactiva (permitir el link) en una ficha 
    *   
    * @param string $llave El codigo de la ficha en cuestin 
    * @param bool $estado true si se quiere activa, false otherwhise 
    */ 
    function estadoFicha($llave,$estado="") { 
        // Si la llave no existe, devuelve vacio 
        if (!array_key_exists($llave,$this->CFG)) 
            return ""; 
         
        if ($estado === "") { 
            return isset($this->CFG[$llave][DISABLED]) ? 
                    !$this->CFG[$llave][DISABLED] : 
                    true; 
        } else { 
            $this->CFG[$llave][DISABLED] = !(bool)$estado; 
            return (bool)$estado; 
        } 
    } 
    /** 
    * Cambia la ficha activa a solicitud del usuario 
    *   
    * @param array $In El vector con las entradas del usuario 
    */ 
    function cambiarActiva(&$In) { 
        if (isset($In[$this->FA_name]) && 
            strlen($In[$this->FA_name]) > 0 && 
            array_key_exists($In[$this->FA_name],$this->CFG) && 
            !$this->CFG[$In[$this->FA_name]][DISABLED]) { 
            // Ficha activa la que le dijeron 
            $this->Activa = $In[$this->FA_name]; 
            return true; 
        } else { 
            // La primera que no este inactiva pues la otra no es vlida 
            foreach(array_keys($this->CFG) as $act) { 
                if (!$this->CFG[$act][DISABLED]) { 
                    $this->Activa = $act; 
                    return true; 
                } 
            } 
            return false; 
        } 
    } 
    /** 
    * Despliega el html con el formulario 
    * 
    */ 
    function htmlPanel() { 
        $s  = "<table {$this->TAttr}>\n" 
            . "<tr><TD>\n" 
            . "\t<table width=\"100%\" cellpadding=\"3\" cellspacing=\"0\"><TR>\n"; 
        foreach(array_keys($this->CFG) as $key) { 
            $fmt = ($this->Activa == $key) ? $this->ACAttr : $this->ICAttr; 
            // Imprime las celdas, una ficha en cada una             
            $s .= "\t<td nowrap $fmt>&nbsp;\n"; 
                if ($this->CFG[$key][DISABLED] === true) { 
                    $s .= $this->CFG[$key][LABEL] . "&nbsp;</td>\n"; 
                } else { 
                    $s .= "\t\t<a href=\"" . $_SERVER['PHP_SELF'] . "?" 
                        . $this->FA_name . "=" . $key . "\">" 
                        . $this->CFG[$key][LABEL] . "</a>&nbsp;</td>\n"; 
                } 
        } 
        // Imprime la celda mas derecha, la que arriba a las otras 
        $s .= "\t<td width=\"80%\">&nbsp;</td>\n"; 
        $s .= "\t</tr>\n\t</table>\n</td></tr>\n" 
            . "<TR><td height=\"200\" {$this->ACAttr}>"; 
        // Coloca el contenido de la ficha en su celda 
        switch ($this->CFG[$this->Activa][TYPE]) { 
            case "INCLUDE": 
                if (file_exists($this->CFG[$this->Activa][CONTENT])) 
                    echo $s; 
                    include($this->CFG[$this->Activa][CONTENT]); 
                    $s = ""; 
                break; 
            case "STRING": 
            default: 
                $s .= $this->CFG[$this->Activa][CONTENT]; 
                break; 
        } 
        $s .= "</td></tr>\n</table>"; 
        echo $s; 
    } 
} 
?>